//==========================================================================
// File Name   : ComAir5_IOTX_User.asm
// Description : Users implement functions
// Written by  : Porter Yang
// Last modified date:
//              2013/05/10
// Note: 
//==========================================================================
//**************************************************************************
// Header File Included Area
//**************************************************************************
.include GPCE2P064.inc

//**************************************************************************
// Contant Defintion Area
//**************************************************************************

//**************************************************************************
// Variable Publication Area
//**************************************************************************
.public T_SYSTEMCLK

//**************************************************************************
// Function Call Publication Area
//**************************************************************************
.public F_ComAir5_IOTX_HW_Init
.public F_ComAir5_IOTX_WriteTimerData
.public F_ComAir5_IOTX_ReadTimerData
.public F_ComAir5_IOTX_INT_ON
.public F_ComAir5_IOTX_INT_OFF

//**************************************************************************
// External Function Declaration
//**************************************************************************

.external F_SACM_Delay
//**************************************************************************
// External Table Declaration
//**************************************************************************

//**************************************************************************
// RAM Definition Area
//**************************************************************************

//*****************************************************************************
// Table Definition Area
//*****************************************************************************
.TEXT
T_SYSTEMCLK:	
	.DD	SystemClock;		// SystemClock is define in GPCE063.inc

//**************************************************************************
// CODE Definition Area
//**************************************************************************
.CODE
//****************************************************************
// Function    : F_ComAir_IOTX_Init_
// Description : Hardware initilazation for COMAIR_IOTX, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_ComAir5_IOTX_HW_Init:	
	IRQ OFF;
	FIR_MOV OFF;
	
	R1 = [P_Timer_Ctrl]	
	R1 |= C_TimerA_FPLL;			// TimerA CKA=Fosc/2 CKB=1 Tout:off
	R1 |= C_TimerC_FPLL;			
	[P_Timer_Ctrl] = R1;

	R1= C_Timer_Setting_8K;			// TimerA setting
	[P_TimerA_Data] = R1;
	[P_TimerA_CNTR] = R1;

	R1 = C_DAC_Scaler_Disable | C_DAC_Half_Vol_Disable | C_DAC_Enable;
	R1 |= C_DAC_CH2_Up_Sample_Disable | C_DAC_CH2_Disable | C_DAC_CH2_TMR_Sel_TimerA;
	R1 |= C_DAC_CH1_Up_Sample_Enable | C_DAC_CH1_Enable | C_DAC_CH1_TMR_Sel_TimerA;
	[P_DAC_Ctrl] = R1;	
	
	R1 = C_Ext_DAC_In_Enable | C_PP_NMOS_Enable | C_PP_Gain_LV11;
	[P_PPAMP_Ctrl] = R1;
	call F_SACM_Delay;
	R1 |= C_PP_PMOS_Enable;
	[P_PPAMP_Ctrl] = R1;

	R1 = C_IOPWM_Mask_Disable | C_IOPWM_SRC_TimerC | C_IOPWM_1_Div_2;
	[P_PWM_Ctrl] = R1;

	R1 = [P_INT_Ctrl];
	R1 |= C_IRQ6_4096Hz;
	[P_INT_Ctrl] = R1;
	
	IRQ ON;
	retf;

//****************************************************************
// Function    : F_ComAir5_IOTX_WriteTimerData
// Description : Write Timer Data, called by library
// Destory     : R1
// Parameter   : R3
// Return      : None
// Note        : None
//****************************************************************
F_ComAir5_IOTX_WriteTimerData:
	[P_TimerC_Data] = R3;
	retf;
	
//****************************************************************
// Function    : F_ComAir5_IOTX_ReadTimerData
// Description : Read Timer Data, called by library
// Destory     : R1
// Parameter   : None
// Return      : R3
// Note        : None
//****************************************************************
F_ComAir5_IOTX_ReadTimerData:
	R3 = [P_TimerC_Data];
	retf;	    

//****************************************************************
// Function    : F_ComAir5_IOTX_INT_ON
// Description : This function called by library
// Destory     : None
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_ComAir5_IOTX_INT_ON:	
	IRQ ON;
	retf;

//****************************************************************
// Function    : F_ComAir5_IOTX_INT_OFF
// Description : This function called by library
// Destory     : None
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_ComAir5_IOTX_INT_OFF:
	IRQ OFF;
	retf;	
	